package com.qboxus.tictic.adapters;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager2.adapter.FragmentStateAdapter;

import java.util.ArrayList;
import java.util.List;

public class ViewPagerAdapter2 extends FragmentStateAdapter {
    private final List<Fragment> mFragmentList = new ArrayList<>();

    public ViewPagerAdapter2(Fragment fragment) {
        super(fragment);
    }

    public ViewPagerAdapter2(FragmentActivity fragmentActivity) {
        super(fragmentActivity);
    }

    @NonNull
    @Override
    public Fragment createFragment(int position) {
        return mFragmentList.get(position);
    }


    public void addFrag(Fragment fragment) {
        mFragmentList.add(fragment);
    }


    public Fragment getFragments(int pos) {
        return mFragmentList.get(pos);
    }

    public void removeFrag(int index) {
        mFragmentList.remove(index);
    }

    public void clearFragments() {
        mFragmentList.clear();
    }

    @Override
    public int getItemCount() {
        return mFragmentList.size();
    }


}